#include <cmath>
#include <vector>
#include <iostream>

using namespace std;

vector<int> primesTo(10000000);

int Get(int);
int PrimesBtw(int, int);
bool Prime(int);
void Init();

int main() {
    Init();
    int q;
    vector<int> n(10000000);
    cin >> q;
    for (int i = 0; i < q; i++) {
        cin >> n[i];
    }
    for (int i = 0; i < q; i++) {
        cout << Get(n[i]) << endl;
    }
    return 0;
}

void Init() {
    primesTo[0] = 0;
    primesTo[1] = 0;
    primesTo[2] = 0;
    int counter = 1;
    for (int i = 3; i < 100000; i += 2) {
        primesTo[i] = counter;
        if (Prime(i)) {
            counter++;
        }
        primesTo[i + 1] = counter;
    }
}
bool Prime(int n) {
    float bound = sqrt(n);
    for (int i = 2; i <= bound; i++) {
        if (!(n % i)) {
            return false;
        }
    }
    return true;
}
int PrimesBtw(int a, int b) {
    return primesTo[a] - primesTo[b] + 1;
}
int Get(int n) {
    return n - PrimesBtw(n, n / 2);
}